// $Id: CTrace.cpp,v 1.2 2007/02/08 21:06:44 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CTrace.hpp"
using Exponent::Testing::CTrace;

#ifndef WIN32
	#include <iostream>
	using namespace std;
#endif

//	===========================================================================
CTextStream CTrace::CTRACE_STREAM;

//	===========================================================================
void CTrace::trace(const char *text, ...)
{
	char string[300];
	va_list marker;
	va_start(marker, text);
	vsprintf(string, text, marker);
	if (!string)
	{
		strcpy (string, "Empty string\n");
	}
#ifdef DEBUG
#ifdef WIN32
	OutputDebugString(string);
	OutputDebugString("\n");
#else
	cerr << string << "\n" << endl;
#endif
#endif
	// Stream to disk
	if (CTRACE_STREAM.isStreamOpen())
	{
		CString cstring = string;
		CTRACE_STREAM << cstring << "\n";
		CTRACE_STREAM.flushToDisk();
	}
}

//	===========================================================================
void CTrace::trace(const CCountedObject &theObject, const CString &formatText)
{
	char description[1024];
	theObject.getObjectDescription(description, 1024);
	CString theText = formatText;
	theText += description;
#ifdef DEBUG
#ifdef WIN32
	OutputDebugString(theText.getString());
	OutputDebugString("\n");
#else
	cerr << theText.getString() << "\n" << endl;
#endif
#endif
	// Stream to disk
	if (CTRACE_STREAM.isStreamOpen())
	{
		CTRACE_STREAM << theText << "\n";
		CTRACE_STREAM.flushToDisk();
	}
}

//	===========================================================================
bool CTrace::openTraceFile(const CSystemString &filename)
{
	// Close the old stream
	if (CTRACE_STREAM.isStreamOpen())
	{
		CTRACE_STREAM.closeStream();
	}

	// Open the new stream
	return CTRACE_STREAM.openStream(filename, CTextStream::e_output);
}

//	===========================================================================
void CTrace::closeTraceFile()
{
	CTRACE_STREAM.closeStream();
}